// Learn cc.Class:WhileCircle
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
let Util=require("Util");
cc.Class({
    extends: cc.Component,
    properties: {
        graphics:cc.Graphics,
        color:cc.color(),
        cueNode:cc.Node,
        lineNodeGr:cc.Graphics,
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad:function() {
        console.log('WhileCircle onLoad');
        let lpo=this.cueNode.getChildByName('potL').position;
        let rpo=this.cueNode.getChildByName('potR').position;
        this.cueNode.getComponent(cc.Graphics).moveTo(lpo.x, lpo.y);
        this.cueNode.getComponent(cc.Graphics).lineTo(rpo.x, rpo.y);
        this.cueNode.getComponent(cc.Graphics).stroke();
        this.circleRadius=30;
        this.graphics.circle(0, 0, this.circleRadius);
        this.graphics.stroke();

        cc.Canvas.instance.node.on(cc.Node.EventType.MOUSE_MOVE, this.onMBMouseMove, this);
        cc.Canvas.instance.node.on(cc.Node.EventType.MOUSE_DOWN, this.onMBMouseDown, this);
        cc.Canvas.instance.node.on(cc.Node.EventType.MOUSE_UP, this.onMBMouseUp, this);
    },

    start:function() {

    },
    onMBMouseMove:function(evt){
        if(evt.currentTarget.isMove){
            this.moveCueAngle(evt);
        }

    },
    onMBMouseDown:function(evt){
        this.node.getChildByName('body').active=false;
        evt.currentTarget.isMove=true;
        /* cc.tween(nodeIco)
             .by(1, { x: -10 })
             .repeatForever()
             .start()*/
    },
    onMBMouseUp:function(evt){
        evt.currentTarget.isMove=false;
        this.node.getChildByName('body').active=true;
        //计算白球运动的方向向量
        let loc=evt.getLocation();
        let direction = this.node.parent.convertToNodeSpaceAR(loc);
        // direction = direction.sub(this.node.position);
        direction = this.node.position.sub(direction);
        direction = direction.normalize();

        //根据方向和力度，计算并给予白球线速度
        this.node.getChildByName('body').getComponent(cc.RigidBody).linearVelocity = direction.mul(-Math.pow(1.016, Math.abs(500)));
    },

    /**球杆角度转换
     * @param evt  世界坐标
     */
    moveCueAngle:function(evt){
        //鼠标 世界坐标
        let loc = evt.getLocation();

        //将世界坐标转换到节点的坐标系下
        loc = this.cueNode.parent.convertToNodeSpaceAR(loc);
        //
        let mpo=this.cueNode.position;
        //mpo到loc相对于x轴夹角
        let angle = Math.atan2(loc.y - mpo.y, loc.x - mpo.x) * 180 / Math.PI
        this.cueNode.angle  = angle;

        let cpAr=this.cueNode.getChildByName('potC').convertToWorldSpaceAR(cc.Vec2(0,0));
        let lpAr=this.cueNode.getChildByName('potL').convertToWorldSpaceAR(cc.Vec2(0,0));

        let c_loc=evt.getLocation();
        let cstart=this.cueNode.getChildByName('potC').convertToWorldSpaceAR(cc.Vec2(0,0))
        let direction = c_loc.sub(cstart);
        direction = direction.normalize();

       /* let cend = cstart.add(direction.mul(500));
        this.lineNodeGr.moveTo(cstart.x, cstart.y);
        this.lineNodeGr.lineTo(c_loc.x, c_loc.y);
        this.lineNodeGr.stroke();*/

        this.draeCliceP(30,cpAr,lpAr,direction,angle);
    },

    /**画半圆上的点
     *@radius 园半径
     *@cpAr 圆中心点 世界坐标
     *@lpAr 圆上一点坐标 世界坐标
     *@direction 向量
     *@nodeangle 球杆旋转角度
     **/
    draeCliceP:function(radius,cpAr,lpAr,direction,nodeangle){
        this.lineNodeGr.clear();
        //画线node坐标
        let lpp=this.lineNodeGr.node.convertToNodeSpaceAR(lpAr);
        let cpp=this.lineNodeGr.node.convertToNodeSpaceAR(cpAr);

        let itemJiao=2;
        let pointList=[];
        let pi=Math.PI/180;
        for(let i=0;i<=180;i++){
            let jiaoA=(i*itemJiao+nodeangle-90)*pi;
            let x1=cpp.x+radius*Math.cos( jiaoA );
            let y1=cpp.y+radius*Math.sin( jiaoA );
            let start=new cc.Vec2(x1,y1);
            let end = start.add(direction.mul(1000));
            //画线
            /*this.lineNodeGr.circle(start.x, start.y, 1);
            this.lineNodeGr.moveTo(start.x, start.y);
            this.lineNodeGr.lineTo(end.x, end.y);
            this.lineNodeGr.stroke();*/

            let sAr=this.lineNodeGr.node.convertToWorldSpaceAR(start);
            let eAr=this.lineNodeGr.node.convertToWorldSpaceAR(end);

            pointList.push({s:sAr,e:eAr});

        }
       this.rayCast(pointList);
    },
    /**射线检测**/
    rayCast:function(list){
        //console.log(list);
        let collList=[];
        for(let i=0;i<list.length;i++){
            // 射线
            let results = cc.director.getPhysicsManager().rayCast(list[i].s, list[i].e, cc.RayCastType.Any);
            if(results.length>0){
                let result = results[0];
                // 指定射线与穿过的碰撞体在哪一点相交。
                let point = result.point;
                collList.push({s:list[i].s,e:point,result:result})
               // console.log('rayCast point',point);
                //break;
            }
        }
        if(collList.length>0){
            collList.sort(this.Arrayfunc);
           // console.log('rayCast',collList);
            console.log('rayCast',collList[0].e);
            this.drawXFLine(collList[0]);

        }

    },
    Arrayfunc:function(a,b){
        let as=a.s,ae=a.e;
        let bs=b.s,be=b.e;
        let alen=Math.sqrt((as.x - ae.x) * (as.x - ae.x) + (as.y - ae.y) * (as.y - ae.y));
        let blen=Math.sqrt((bs.x - be.x) * (bs.x - be.x) + (bs.y - be.y) * (bs.y - be.y));
        return alen-blen;
    },
    /**画方向线**/
    drawXFLine:function(vo){
        let pStart=vo.s;
        let pEnd=vo.e;
        //画线node坐标
        let sp=this.lineNodeGr.node.convertToNodeSpaceAR(pStart);
        let ep=this.lineNodeGr.node.convertToNodeSpaceAR(pEnd);

        let redNode=vo.result.collider.node;
        let redC=Util.getNodePos(redNode,this.lineNodeGr.node);

        //画切割圆
        let circleDirection = ep.sub(redC);
        circleDirection = circleDirection.normalize();
        let circlePo = ep.add(circleDirection.mul(this.circleRadius));
        this.lineNodeGr.circle(circlePo.x, circlePo.y, this.circleRadius);
        this.lineNodeGr.stroke();

        //红球方向线
        let rfxDirection = redC.sub(ep);
        rfxDirection = rfxDirection.normalize();
        let rfxPo = redC.add(rfxDirection.mul(this.circleRadius));
        let rfxAdd=redC.add(rfxDirection.mul(this.circleRadius*5));
        this.lineNodeGr.moveTo(rfxPo.x, rfxPo.y);
        this.lineNodeGr.lineTo(rfxAdd.x, rfxAdd.y);
        this.lineNodeGr.stroke();




        this.lineNodeGr.moveTo(sp.x, sp.y);
        this.lineNodeGr.lineTo(ep.x, ep.y);
        this.lineNodeGr.stroke();
    },
    // update (dt) {},
});
